/*
 * Created on Aug 1, 2003
 */
package Interface;

import Validators.*;
import Data.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;

/**
 * @author student
 * This class is being used to implement the Login 
 * 
 */
public class TabLogin extends JFrame implements ActionListener {

	//boolean inAnApplet = true;	

	static JLabel uLabel = new JLabel("User Name");
	static JTextField userName = new JTextField(15);
	static JLabel pLabel = new JLabel("Password");
	static JPasswordField password = new JPasswordField(15);
	static JButton loginButton = new JButton("LOGIN");
	static JButton registerButton = new JButton("REGISTER");
	static JLabel message = new JLabel();

	private static UserData user = new UserData();

	/**
	 * This is the constructor for TabLogin.java
	 */
	public TabLogin() {
		super();
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				displayMessage("Window closing", e);
				dispose();
				System.exit(0);

			}
			public void windowClosed(WindowEvent e) {
				displayMessage("Window closed", e);
			}
			public void windowOpened(WindowEvent e) {
				displayMessage("Window opened", e);
			}

			public void windowIconified(WindowEvent e) {
				displayMessage("Window iconified", e);
			}

			public void windowDeiconified(WindowEvent e) {
				displayMessage("Window deiconified", e);
			}

			public void windowActivated(WindowEvent e) {
				displayMessage("Window activated", e);

			}

			public void windowDeactivated(WindowEvent e) {
				displayMessage("Window deactivated", e);
			}
		});

		displayWindow();
		createPanel();
	}
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if (e.getActionCommand() == "enter") {
			doLogin();
		}

		if (command == "login") {
			doLogin();

		}
		if (command == "register") {
			TabRegister register = new TabRegister(this);
			this.dispose();

		}
	}

	/**
	 * This method is called when the user presses login
	 *  void
	 */
	public void doLogin() {

		user.setLoginId(userName.getText());
		user.setPassword(password.getText());
		LoginValidator lv = new LoginValidator();
		if (!lv.validate(user)) {
			message.setText("Login Failed: " + "\n" + lv.getMessage());
			return;
		} else {
//			System.out.println("Id while loging in" + user.getLoginId());			
			Pinboard window = new Pinboard(user);
			//getUserDetails();	
			this.setVisible(false);
		}
	}

	/**
	 * This method is being used to display window event messages
	 */
	void displayMessage(String prefix, WindowEvent e) {
//		System.out.println(prefix + ": " + e.getWindow() + "\n");
	}

	/**
	 * This method is being used to display login window
	 *  void
	 */
	void displayWindow() {
		//this.inAnApplet = false;
		JFrame.setDefaultLookAndFeelDecorated(true);
		this.setSize(500, 250);
		//this.setLocation(300,200);
		centerDialog(this);
		this.setTitle("Pinboard Application");
		ImageIcon img = new ImageIcon("./Interface/pinboard.gif");
		this.setIconImage(img.getImage());

	}
	/**
	 * This method is being used to create login Panel
	 *  void
	 */
	void createPanel() {

		Container contentPane = getContentPane();

		TitledBorder loginTitled = BorderFactory.createTitledBorder("Login");
		JPanel lPanel = new JPanel();
		lPanel.setBorder(loginTitled);
		lPanel.setLayout(new BoxLayout(lPanel, BoxLayout.Y_AXIS));

		JPanel uPanel = new JPanel();
		JPanel pPanel = new JPanel();
		JPanel buttonPanel = new JPanel();

		uPanel.setLayout(new FlowLayout());
		pPanel.setLayout(new FlowLayout());
		buttonPanel.setLayout(new FlowLayout());

		uPanel.add(uLabel);
		uLabel.setLabelFor(userName);
		userName.setSize(15, 10);
		userName.setEditable(true);
		userName.setActionCommand("enter");
		userName.addActionListener(this);
		uPanel.add(userName);

		pPanel.add(pLabel);
		pLabel.setLabelFor(password);
		password.setEditable(true);
		password.setActionCommand("enter");
		password.addActionListener(this);
		pPanel.add(password);

		lPanel.add(uPanel);
		lPanel.add(pPanel);

		buttonPanel.add(loginButton);
		buttonPanel.add(registerButton);
		lPanel.add(buttonPanel);

		loginButton.setActionCommand("login");
		loginButton.addActionListener(this);
		registerButton.setActionCommand("register");
		registerButton.addActionListener(this);

		message.setHorizontalAlignment(SwingConstants.LEFT);
		message.setFont(new Font("Times New Roman", Font.ITALIC, 16));
		message.setForeground(Color.RED);
		lPanel.add(message);

		contentPane.add(lPanel, BorderLayout.CENTER);

		this.setVisible(true);

	}
//	/**
//	 * This method is could  be used to get User details from TMS
//	 *  void
//	 */
//	private void getUserDetails() {
//
//		//		String xmlstr = XmlGenerator.enquiryNcbXml(user);
//		//		  String out = ServletConnection.sendXml(xmlstr);
//		//	
//		//		  String message = XmlUnmarshal.readResponse(out);
//		//		  user =  XmlUnmarshal.getUser(user);
//		//	
//		//		  //fetch address details.
//		//		  //UserData userdata = new UserData();
//		//	
//		//		  String xmlstr2 = XmlGenerator.enquiryNcbAddressXml(user);
//		//		  String out2 = ServletConnection.sendXml(xmlstr2);
//		//	
//		//		  String message2 = XmlUnmarshal.readResponse(out2);
//		//		  user = XmlUnmarshal.getUser(user);
//		//		System.out.println(user.getEmailAddress());
//		//		System.out.println( user.getFName());
//
//	}
	/**
	 * This method is being used center the login window
	 * @param frame void
	 */
	//	Center a dialog on screen
	public static void centerDialog(Window frame) {
		Dimension dialogSize = frame.getSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation(
			screenSize.width / 2 - dialogSize.width / 2,
			screenSize.height / 2 - dialogSize.height / 2);
	}

}
